﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using VIRP_WEB.SoaServices;

namespace VIRP_WEB.BaseCode
{
    [Serializable()]
    public class UserSession
    {
        private bool isSystemAdministrator;
        private bool isSystemUpdate;
        private bool isSystemRead;

        private bool isRegistryAdministrator;
        private bool isRegistryUpdate;
        private bool isRegistryRead;

        private bool isBprAccessLogged;

        private string patientSearch;
        private string currentReportPath;
        private string currentRegistry;
        private int currentUserId;
        private int currentRegistryId;
        private int currentReferralId;
        private int currentPatientId;
        private int currentProviderId;
        private int currentWorkstreamId;
        private int currentActivityId;
        private int currentSurveyId;
        private int? defaultRegistryId;
        private bool filterBySelectedPatient;

        private string bprFormId;

        private PageModes pageMode;

        public UserSession()
        {
            this.Refresh();
        }

        public bool IsSystemAdministrator
        {
            get 
            { 
                return this.isSystemAdministrator; 
            }
            set
            {
                this.isSystemAdministrator = value;
                HttpContext.Current.Session["UserSession"] = this;
            }
        }

        public bool IsSystemUpdate
        {
            get { return this.isSystemUpdate; }
        }

        public bool IsSystemRead
        {
            get { return this.isSystemRead; }
        }

        public bool IsRegistryAdministrator
        {
            get 
            { 
                return this.isRegistryAdministrator; 
            }
            set
            {
                this.isRegistryAdministrator = value;
                HttpContext.Current.Session["UserSession"] = this;
            }
        }

        public bool IsRegistryUpdate
        {
            get { return this.isRegistryUpdate; }
        }

        public bool IsRegistryRead
        {
            get { return this.isRegistryRead; }
        }

        public bool IsBprAccessLogged
        {
            get { return this.isBprAccessLogged; }
            set { this.isBprAccessLogged = value; }
        }

        public string PatientSearch
        {
            get
            {
                return this.patientSearch;
            }
            set
            {
                this.patientSearch = value;
                HttpContext.Current.Session["UserSession"] = this;
            }
        }

        public string CurrentReportPath
        {
            get
            {
                return this.currentReportPath;
            }
            set
            {
                this.currentReportPath = value;
                HttpContext.Current.Session["UserSession"] = this;
            }
        }

        public string CurrentRegistry
        {
            get
            {
                return this.currentRegistry;
            }
            set
            {
                this.currentRegistry = value;
                HttpContext.Current.Session["UserSession"] = this;
            }
        }

        public int CurrentUserId
        {
            get
            {
                return this.currentUserId;
            }
            set
            {
                this.currentUserId = value;
                HttpContext.Current.Session["UserSession"] = this;
            }
        }

        public int CurrentRegistryId
        {
            get
            {
                return this.currentRegistryId;
            }
            set
            {
                this.currentRegistryId = value;
                HttpContext.Current.Session["UserSession"] = this;
            }
        }

        public int? DefautRegistryId
        {
            get
            {
                return this.defaultRegistryId;
            }
            set
            {
                this.defaultRegistryId = value;
                HttpContext.Current.Session["UserSession"] = this;
            }
        }

        public int CurrentReferralId
        {
            get
            {
                return this.currentReferralId;
            }
            set
            {
                this.currentReferralId = value;
                HttpContext.Current.Session["UserSession"] = this;
            }
        }

        public int CurrentPatientId
        {
            get
            {
                return this.currentPatientId;
            }
            set
            {
                this.currentPatientId = value;
                HttpContext.Current.Session["UserSession"] = this;
            }
        }

        public int CurrentProviderId
        {
            get
            {
                return this.currentProviderId;
            }
            set
            {
                this.currentProviderId = value;
                HttpContext.Current.Session["UserSession"] = this;
            }
        }

        public int CurrentWorkstreamId
        {
            get
            {
                return this.currentWorkstreamId;
            }
            set
            {
                this.currentWorkstreamId = value;
                HttpContext.Current.Session["UserSession"] = this;
            }
        }

        public int CurrentActivityId
        {
            get
            {
                return this.currentActivityId;
            }
            set
            {
                this.currentActivityId = value;
                HttpContext.Current.Session["UserSession"] = this;
            }
        }

        public int CurrentSurveyId
        {
            get
            {
                return this.currentSurveyId;
            }
            set
            {
                this.currentSurveyId = value;
                HttpContext.Current.Session["UserSession"] = this;
            }
        }

        public PageModes PageMode
        {
            get 
            { 
                return this.pageMode; 
            }
            set 
            { 
                this.pageMode = value;
                HttpContext.Current.Session["UserSession"] = this;
            }
        }

        public bool FilterBySelectedPatient
        {
            get
            {
                return this.filterBySelectedPatient;
            }
            set
            {
                this.filterBySelectedPatient = value;
                HttpContext.Current.Session["UserSession"] = this;
            }
        }

        public string BprFormId
        {
            get
            {
                return this.bprFormId;
            }
            set
            {
                this.bprFormId = value;
                HttpContext.Current.Session["BprFormId"] = this;
            }
        }

        public void Refresh()
        {
            this.isSystemAdministrator = false;
            this.isSystemUpdate = false;
            this.isSystemRead = false;
            this.isRegistryAdministrator = false;
            this.isRegistryUpdate = false;
            this.isRegistryRead = false;
           
            string[] roles = ServiceInterfaceManager.USER_ROLES_GET_ROLES(HttpContext.Current.User.Identity.Name);
            if (roles != null)
            {
                foreach (string role in roles)
                {
                    if (role == "CRSADMIN")
                        this.isSystemAdministrator = true;
                    else if (role == "CRSUPD")
                        this.isSystemUpdate = true;
                    else if (role == "CRSREAD")
                        this.isSystemRead = true;
                    else if (role == "REGADMIN")
                        this.isRegistryAdministrator = true;
                    else if (role == "REGUPD")
                        this.isRegistryUpdate = true;
                    else if (role == "REGREAD")
                        this.isRegistryRead = true;
                }
            }

            this.patientSearch = string.Empty;
            this.currentReportPath = string.Empty;
            this.currentRegistry = string.Empty;
            this.currentRegistryId = 0;
            this.currentReferralId = 0;
            this.currentPatientId = 0;
            this.currentProviderId = 0;
            this.currentWorkstreamId = 0;
            this.currentActivityId = 0;
            this.currentSurveyId = 0;
            this.defaultRegistryId = 0;

            this.pageMode = PageModes.None;

            USERS user = ServiceInterfaceManager.USERS_GET_BY_NAME(HttpContext.Current.User.Identity.Name, this.currentRegistryId, HttpContext.Current.User.Identity.Name);
            if (user != null)
                this.currentUserId = user.USER_ID;

            HttpContext.Current.Session["UserSession"] = this;
        }

        public void RefreshCommon()
        {
            this.currentReferralId = 0;
            this.currentPatientId = 0;
            this.currentProviderId = 0;
            this.currentWorkstreamId = 0;
            this.currentActivityId = 0;
            this.currentSurveyId = 0;
            this.defaultRegistryId = 0;

            HttpContext.Current.Session["UserSession"] = this;
        }

        public bool CheckSystemAccess()
        {
            bool blnReturn = false;

            if (this.isSystemAdministrator || this.isSystemUpdate || this.isSystemRead)
                blnReturn = true;

            return blnReturn;
        }

        public bool CheckRegistryAccess()
        {
            return this.CheckRegistryAccess(this.currentRegistryId);
        }

        public bool CheckRegistryAccess(int registryId)
        {
            bool blnReturn = false;

            List<USER_ROLES> roles = ServiceInterfaceManager.USER_ROLES_GET_ALL_BY_USER(HttpContext.Current.User.Identity.Name, registryId, this.currentUserId);
            if (roles != null)
            {
                foreach (USER_ROLES role in roles)
                {
                    if (role.STD_ROLE != null && role.STD_ROLE.STD_REGISTRY_ID == registryId && (role.STD_ROLE.CODE == "REGADMIN" || role.STD_ROLE.CODE == "REGUPD" || role.STD_ROLE.CODE == "REGREAD"))
                        blnReturn = true;
                }
            }

            return blnReturn;
        }

        public bool CheckRegistryAdministrator()
        {
            return this.CheckRegistryAdministrator(this.currentRegistryId);
        }

        public bool CheckRegistryAdministrator(int registryId)
        {
            bool blnReturn = false;

            List<USER_ROLES> roles = ServiceInterfaceManager.USER_ROLES_GET_ALL_BY_USER(HttpContext.Current.User.Identity.Name, registryId, this.currentUserId);
            if (roles != null)
            {
                foreach (USER_ROLES role in roles)
                {
                    if (role.STD_ROLE != null && role.STD_ROLE.STD_REGISTRY_ID == registryId && role.STD_ROLE.CODE == "REGADMIN")
                        blnReturn = true;
                }
            }

            return blnReturn;
        }

        public bool CheckRegistryUpdate()
        {
            return this.CheckRegistryUpdate(this.currentRegistryId);
        }

        public bool CheckRegistryUpdate(int registryId)
        {
            bool blnReturn = false;

            List<USER_ROLES> roles = ServiceInterfaceManager.USER_ROLES_GET_ALL_BY_USER(HttpContext.Current.User.Identity.Name, registryId, this.currentUserId);
            if (roles != null)
            {
                foreach (USER_ROLES role in roles)
                {
                    if (role.STD_ROLE != null && role.STD_ROLE.STD_REGISTRY_ID == registryId && role.STD_ROLE.CODE == "REGUPD")
                        blnReturn = true;
                }
            }

            return blnReturn;
        }

        public bool CheckRegistryRead()
        {
            return this.CheckRegistryRead(this.currentRegistryId);
        }

        public bool CheckRegistryRead(int registryId)
        {
            bool blnReturn = false;

            List<USER_ROLES> roles = ServiceInterfaceManager.USER_ROLES_GET_ALL_BY_USER(HttpContext.Current.User.Identity.Name, registryId, this.currentUserId);
            if (roles != null)
            {
                foreach (USER_ROLES role in roles)
                {
                    if (role.STD_ROLE != null && role.STD_ROLE.STD_REGISTRY_ID == registryId && role.STD_ROLE.CODE == "REGREAD")
                        blnReturn = true;
                }
            }

            return blnReturn;
        }
        // Intended to be used as follows:
        // ChildUserSession childUserSession = currentParentUserSession.deepCopyInto(new ChildUserSession());
        // This essentially allows the parent object to be "upgraded" with child-specific properties at runtime, all without breaking strong-typing.
        public T deepCopyInto<T>(T session) where T : UserSession
        {
            session.isSystemAdministrator = isSystemAdministrator;
            session.isSystemUpdate = isSystemUpdate;
            session.isSystemRead = isSystemRead;
            session.isRegistryAdministrator = isRegistryAdministrator;
            session.isRegistryUpdate = isRegistryUpdate;
            session.isRegistryRead = isRegistryRead;
            session.isBprAccessLogged = isBprAccessLogged;
            session.patientSearch = patientSearch;
            session.currentReportPath = currentReportPath;
            session.currentRegistry = currentRegistry;
            session.currentUserId = currentUserId;
            session.currentRegistryId = currentRegistryId;
            session.currentReferralId = currentReferralId;
            session.currentPatientId = currentPatientId;
            session.currentProviderId = currentProviderId;
            session.currentWorkstreamId = currentWorkstreamId;
            session.currentActivityId = currentActivityId;
            session.currentSurveyId = currentSurveyId;
            session.defaultRegistryId = defaultRegistryId;
            session.filterBySelectedPatient = filterBySelectedPatient;
            session.bprFormId = bprFormId;
            session.pageMode = pageMode;

            return session;
        }
    }
}